/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class JarTool {
    public static String getJarPath() {
        File file = JarTool.getFile();
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static File getJarDir() {
        File file = JarTool.getFile();
        if (file == null) {
            return null;
        }
        return JarTool.getFile().getParentFile();
    }

    public static String getJarName() {
        File file = JarTool.getFile();
        if (file == null) {
            return null;
        }
        return JarTool.getFile().getName();
    }

    public static File getFile() {
        String path = JarTool.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        path = URLDecoder.decode(path, StandardCharsets.UTF_8);
        return new File(path);
    }

    public static void inputStreamFile(InputStream inputStream, String targetFilePath) {
        File file = new File(targetFilePath);
        try {
            FileOutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            os.flush();
            ((OutputStream)os).close();
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> readFileLinesFromJar(String path) {
        ArrayList<String> arrayList;
        BufferedReader br = new BufferedReader(new InputStreamReader(Objects.requireNonNull(JarTool.class.getClassLoader().getResourceAsStream(path))));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        br.close();
        return arrayList;
    }
}

